<?php
/*
Plugin Name: Tefagoo Auto Slug Translate
Description: ترجمة الرابط الدائم (Slug) من العربي للإنجليزي تلقائيًا مع إعدادات API وزر في صفحة التحرير.
Version: 1.0
Author: Ahmed Nabel
*/

// =====================
// 1. صفحة الإعدادات
// =====================
add_action('admin_menu', function () {
    add_options_page(
        'Auto Slug Translate',
        'Auto Slug Translate',
        'manage_options',
        'auto-slug-translate',
        'auto_slug_translate_settings_page'
    );
});

function auto_slug_translate_settings_page() {
    if (isset($_POST['api_key'])) {
        update_option('auto_slug_translate_api_key', sanitize_text_field($_POST['api_key']));
        echo '<div class="updated"><p>تم حفظ مفتاح API بنجاح ✅</p></div>';
    }

    $apiKey = get_option('auto_slug_translate_api_key', '');
    ?>
    <div class="wrap">
        <h1>إعدادات Auto Slug Translate</h1>
        <form method="post">
            <label for="api_key">Google Translate API Key:</label><br>
            <input type="text" id="api_key" name="api_key" value="<?php echo esc_attr($apiKey); ?>" style="width:400px;">
            <p><button type="submit" class="button button-primary">حفظ</button></p>
        </form>
    </div>
    <?php
}

// =====================
// 2. فلتر عند الحفظ
// =====================
add_filter('wp_insert_post_data', 'auto_translate_post_slug', 10, 2);

function auto_translate_post_slug($data, $postarr) {
    if ($data['post_type'] == 'post' && $data['post_status'] != 'auto-draft') {
        if (empty($data['post_name'])) {
            $title = $data['post_title'];
            $translated = auto_translate_text($title);
            $data['post_name'] = sanitize_title($translated);
        }
    }
    return $data;
}

// =====================
// 3. دالة الترجمة
// =====================
function auto_translate_text($text) {
    $apiKey = get_option('auto_slug_translate_api_key', '');
    if (empty($apiKey)) {
        return $text; // لو مفيش مفتاح API نرجع النص الأصلي
    }

    $url = "https://translation.googleapis.com/language/translate/v2?key=$apiKey";
    $fields = array(
        'q' => $text,
        'source' => 'ar',
        'target' => 'en',
        'format' => 'text'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    if (isset($result['data']['translations'][0]['translatedText'])) {
        return $result['data']['translations'][0]['translatedText'];
    } else {
        return $text;
    }
}

// =====================
// 4. زر في شاشة المقالة
// =====================
add_action('post_submitbox_misc_actions', 'add_translate_button');

function add_translate_button($post) {
    echo '<div class="misc-pub-section">';
    echo '<button type="button" class="button" id="translate-slug-btn">ترجمة الرابط بالإنجليزية</button>';
    echo '</div>';
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($){
        $('#translate-slug-btn').on('click', function(){
            let title = $('#title').val();
            if(!title){
                alert('اكتب عنوان المقالة أولاً');
                return;
            }
            $.post(ajaxurl, {
                action: 'translate_slug',
                title: title
            }, function(response){
                if(response.success){
                    $('#editable-post-name').text(response.data.slug);
                    $('#post_name').val(response.data.slug);
                } else {
                    alert('تعذر الترجمة: ' + response.data);
                }
            });
        });
    });
    </script>
    <?php
}

// =====================
// 5. Ajax لترجمة العنوان
// =====================
add_action('wp_ajax_translate_slug', function(){
    if (!current_user_can('edit_posts')) {
        wp_send_json_error('غير مسموح');
    }
    if (empty($_POST['title'])) {
        wp_send_json_error('عنوان فارغ');
    }

    $title = sanitize_text_field($_POST['title']);
    $translated = auto_translate_text($title);
    $slug = sanitize_title($translated);

    wp_send_json_success(['slug' => $slug]);
});
